/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.serializers;

import com.google.gson.JsonObject;
import dev.gigaherz.jsonthings.things.ThingRegistries;
import dev.gigaherz.jsonthings.things.builders.ItemBuilder;
import dev.gigaherz.jsonthings.things.items.FlexArmorItem;
import dev.gigaherz.jsonthings.things.items.FlexAxeItem;
import dev.gigaherz.jsonthings.things.items.FlexBlockItem;
import dev.gigaherz.jsonthings.things.items.FlexBowlFoodItem;
import dev.gigaherz.jsonthings.things.items.FlexBucketItem;
import dev.gigaherz.jsonthings.things.items.FlexDiggerItem;
import dev.gigaherz.jsonthings.things.items.FlexDrinkableBottleItem;
import dev.gigaherz.jsonthings.things.items.FlexHoeItem;
import dev.gigaherz.jsonthings.things.items.FlexItem;
import dev.gigaherz.jsonthings.things.items.FlexPickaxeItem;
import dev.gigaherz.jsonthings.things.items.FlexShovelItem;
import dev.gigaherz.jsonthings.things.items.FlexSwordItem;
import dev.gigaherz.jsonthings.things.items.FlexTieredItem;
import dev.gigaherz.jsonthings.things.serializers.IItemFactory;
import dev.gigaherz.jsonthings.things.serializers.IItemSerializer;
import dev.gigaherz.jsonthings.util.Utils;
import dev.gigaherz.jsonthings.util.parse.JParse;
import dev.gigaherz.jsonthings.util.parse.JParseException;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import joptsimple.internal.Strings;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.mutable.MutableObject;

public class FlexItemType<T extends Item> {
    public static final FlexItemType<FlexItem> PLAIN = FlexItemType.register("plain", data -> FlexItem::new);
    public static final FlexItemType<FlexBlockItem> BLOCK = FlexItemType.register("block", data -> {
        String name = GsonHelper.m_13851_((JsonObject)data, (String)"places", null);
        boolean useBlockName = GsonHelper.m_13855_((JsonObject)data, (String)"use_block_name", (boolean)true);
        return (props, builder) -> {
            ResourceLocation blockName = name != null ? new ResourceLocation(name) : builder.getRegistryName();
            return new FlexBlockItem((RegistryObject<Block>)RegistryObject.create((ResourceLocation)blockName, (IForgeRegistry)ForgeRegistries.BLOCKS), useBlockName, props, builder);
        };
    });
    public static final FlexItemType<FlexBowlFoodItem> FOOD_BOWL = FlexItemType.register("food_bowl", data -> FlexBowlFoodItem::new);
    public static final FlexItemType<FlexDrinkableBottleItem> DRINKABLE_BOTTLE = FlexItemType.register("drinkable_bottle", data -> {
        MutableObject baseItemName = new MutableObject();
        JParse.begin(data).ifKey("base_item", val -> val.string().map(ResourceLocation::new).handle(arg_0 -> ((MutableObject)baseItemName).setValue(arg_0)));
        return (props, builder) -> {
            RegistryObject baseItem = baseItemName.getValue() != null ? RegistryObject.create((ResourceLocation)((ResourceLocation)baseItemName.getValue()), (IForgeRegistry)ForgeRegistries.ITEMS) : () -> Items.f_42590_;
            return new FlexDrinkableBottleItem((Supplier<Item>)baseItem, props, builder);
        };
    });
    public static final FlexItemType<FlexBucketItem> BUCKET = FlexItemType.register("bucket", data -> {
        String name = GsonHelper.m_13851_((JsonObject)data, (String)"fluid", null);
        return (props, builder) -> {
            ResourceLocation fluidName;
            if (name != null) {
                fluidName = new ResourceLocation(name);
            } else {
                ResourceLocation thisName = builder.getRegistryName();
                String path = thisName.m_135815_();
                if (path.endsWith("_bucket")) {
                    path = path.substring(0, path.length() - "_bucket".length());
                }
                fluidName = new ResourceLocation(thisName.m_135827_(), path);
            }
            return new FlexBucketItem((Supplier<Fluid>)Lazy.of(() -> (Fluid)Utils.getOrCrash(ForgeRegistries.FLUIDS, fluidName)), props, builder);
        };
    });
    public static final FlexItemType<FlexArmorItem> ARMOR = FlexItemType.register("armor", data -> {
        MutableObject armorType = new MutableObject();
        MutableObject materialName = new MutableObject();
        JParse.begin(data).requireExactlyOne(List.of("equipment_slot", "armor_type"), () -> new JParseException("Amor item must have an 'armor_type' key, or for backward compatibility, a 'slotName' key.")).ifKey("equipment_slot", val -> val.string().map(Utils::armorTypeByEquipmentSlotName).handle(arg_0 -> ((MutableObject)armorType).setValue(arg_0))).ifKey("armor_type", val -> val.string().map(Utils::armorTypeByName).handle(arg_0 -> ((MutableObject)armorType).setValue(arg_0))).key("material", val -> val.string().map(ResourceLocation::new).handle(arg_0 -> ((MutableObject)materialName).setValue(arg_0)));
        return (props, builder) -> {
            ArmorMaterial material = Utils.getOrCrash(ThingRegistries.ARMOR_MATERIALS, (ResourceLocation)materialName.getValue());
            return new FlexArmorItem(material, (ArmorItem.Type)armorType.getValue(), props, builder);
        };
    });
    public static final FlexItemType<FlexSwordItem> SWORD = FlexItemType.register("sword", FlexItemType.makeToolSerializer2(FlexSwordItem::new));
    public static final FlexItemType<FlexShovelItem> SHOVEL = FlexItemType.register("shovel", FlexItemType.makeToolSerializer(FlexShovelItem::new));
    public static final FlexItemType<FlexAxeItem> AXE = FlexItemType.register("axe", FlexItemType.makeToolSerializer(FlexAxeItem::new));
    public static final FlexItemType<FlexPickaxeItem> PICKAXE = FlexItemType.register("pickaxe", FlexItemType.makeToolSerializer2(FlexPickaxeItem::new));
    public static final FlexItemType<FlexHoeItem> HOE = FlexItemType.register("hoe", FlexItemType.makeToolSerializer2(FlexHoeItem::new));
    public static final FlexItemType<FlexDiggerItem> DIGGER = FlexItemType.register("digger", data -> {
        String tier = FlexItemType.parseTier(data);
        String tagName = GsonHelper.m_13906_((JsonObject)data, (String)"mineable");
        TagKey<Block> tag = Utils.blockTag(tagName);
        float damage = GsonHelper.m_13927_((JsonObject)data, (String)"damage");
        float speed = GsonHelper.m_13915_((JsonObject)data, (String)"speed");
        return (props, builder) -> new FlexDiggerItem(FlexItemType.getTier(tier), damage, speed, tag, props, builder);
    });
    public static final FlexItemType<FlexTieredItem> TIERED = FlexItemType.register("tiered", FlexItemType.makeTieredSerializer(FlexTieredItem::new));
    private final IItemSerializer<T> factory;

    private static <T extends TieredItem> IItemSerializer<T> makeToolSerializer(DiggerFactory<T> factory) {
        return data -> {
            String tier = FlexItemType.parseTier(data);
            float damage = GsonHelper.m_13915_((JsonObject)data, (String)"damage");
            float speed = GsonHelper.m_13915_((JsonObject)data, (String)"speed");
            return (props, builder) -> factory.create(FlexItemType.getTier(tier), damage, speed, props, builder);
        };
    }

    private static <T extends TieredItem> IItemSerializer<T> makeToolSerializer2(DiggerFactory2<T> factory) {
        return data -> {
            String tier = FlexItemType.parseTier(data);
            int damage = GsonHelper.m_13927_((JsonObject)data, (String)"damage");
            float speed = GsonHelper.m_13915_((JsonObject)data, (String)"speed");
            return (props, builder) -> factory.create(FlexItemType.getTier(tier), damage, speed, props, builder);
        };
    }

    private static <T extends TieredItem> IItemSerializer<T> makeTieredSerializer(TieredFactory<T> factory) {
        return data -> {
            String tier = FlexItemType.parseTier(data);
            return (props, builder) -> factory.create(FlexItemType.getTier(tier), props, builder);
        };
    }

    private static Tier getTier(String tierName) {
        return Objects.requireNonNull(TierSortingRegistry.byName((ResourceLocation)new ResourceLocation(tierName)), "The specified tier has not been found in the tier sorting registry");
    }

    private static String parseTier(JsonObject data) {
        String str;
        if (data.has("tier")) {
            str = data.get("tier").getAsString();
            if (Strings.isNullOrEmpty((String)str)) {
                throw new RuntimeException("Tool tier must be a non-empty string.");
            }
        } else {
            throw new RuntimeException("Tool info must have a non-empty 'tier' string.");
        }
        String tierName = str;
        return tierName;
    }

    public static void init() {
    }

    public static <T extends Item> FlexItemType<T> register(String name, IItemSerializer<T> factory) {
        return (FlexItemType)Registry.m_122961_(ThingRegistries.ITEM_TYPES, (String)name, new FlexItemType<T>(factory));
    }

    private FlexItemType(IItemSerializer<T> factory) {
        this.factory = factory;
    }

    public IItemFactory<T> getFactory(JsonObject data) {
        return this.factory.createFactory(data);
    }

    public String toString() {
        return "ItemType{" + ThingRegistries.ITEM_TYPES.m_7981_((Object)this) + "}";
    }

    @FunctionalInterface
    public static interface DiggerFactory<T extends TieredItem> {
        public T create(Tier var1, float var2, float var3, Item.Properties var4, ItemBuilder var5);
    }

    @FunctionalInterface
    public static interface DiggerFactory2<T extends TieredItem> {
        public T create(Tier var1, int var2, float var3, Item.Properties var4, ItemBuilder var5);
    }

    @FunctionalInterface
    public static interface TieredFactory<T extends TieredItem> {
        public T create(Tier var1, Item.Properties var2, ItemBuilder var3);
    }
}

